<?php
require __DIR__ . '/vendor/autoload.php';

\Stripe\Stripe::setApiKey(
    'sk_test_51SuVLBDI0AwUh4kiYVlRYjuArQuh1KNKEeoRsdFv1SYgycsbxphu0i0EDrtOQ6BLrecTclYki28ujNVmoex8Io3500BwmgOH9s'
);
$slackWebhookUrl = "https://hooks.slack.com/services/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"; // replace with your Slack webhook


header('Content-Type: application/json');

try {
    $input = json_decode(file_get_contents('php://input'), true);

    // =========================
    // 1. Validate input
    // =========================
    if (
        empty($input['email']) ||
        empty($input['payment_method_id']) ||
        empty($input['first_name']) ||
        empty($input['last_name']) ||
        empty($input['cardholder_name'])
    ) {
        throw new Exception('Missing required fields');
    }

    $email           = trim($input['email']);
    $firstName       = trim($input['first_name']);
    $lastName        = trim($input['last_name']);
    $paymentMethodId = trim($input['payment_method_id']);

    // =========================
    // 2. Find customers by email
    // =========================
    $customers = \Stripe\Customer::all([
        'email' => $email,
        'limit' => 100,
    ]);

    // =========================
    // 3. Create customer if none exist
    // =========================
    if (empty($customers->data)) {
        $customers->data[] = \Stripe\Customer::create([
            'email' => $email,
            'name'  => $firstName . ' ' . $lastName,
            'metadata' => [
                'first_name' => $firstName,
                'last_name'  => $lastName,
            ],
        ]);
    }

    $updatedCustomers = [];
    $skippedCustomers = [];

    // =========================
    // 4. Process customers
    // =========================
    foreach ($customers->data as $index => $customer) {

        // Update name + metadata (NO array_merge)
        $customer->name = $firstName . ' ' . $lastName;
        $customer->metadata = [
            'first_name' => $firstName,
            'last_name'  => $lastName,
        ];
        $customer->save();

        // Stripe allows ONE PM per customer
        if ($index === 0) {

            // Retrieve PM object
            $paymentMethod = \Stripe\PaymentMethod::retrieve($paymentMethodId);

            // Attach PM to customer (INSTANCE METHOD)
            $paymentMethod->attach([
                'customer' => $customer->id
            ]);

            // Set as default payment method
            \Stripe\Customer::update($customer->id, [
                'invoice_settings' => [
                    'default_payment_method' => $paymentMethodId
                ]
            ]);

            $updatedCustomers[] = $customer->id;

        } else {
            // Cannot reuse PM for other customers
            $skippedCustomers[] = $customer->id;
        }
    }

    // =========================
    // 5. Success response
    // =========================
    echo json_encode([
        'success' => true,
        'updated_customers' => $updatedCustomers,
        'skipped_customers' => $skippedCustomers,
        'message' => 'Card updated for primary customer only (Stripe limitation).'
    ]);
    
    // Send Slack notification
sendSlackMessage(
    $slackWebhookUrl,
    $updatedCustomers,
    $skippedCustomers,
    $firstName,
    $lastName,
    $email,
    $paymentMethodId
);


} catch (\Stripe\Exception\ApiErrorException $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'error' => $e->getMessage()
    ]);
}


function sendSlackMessage($webhookUrl, $updatedCustomers, $skippedCustomers, $firstName, $lastName, $email, $paymentMethodId) {
    $lines = [];

    if (!empty($updatedCustomers)) {
        foreach ($updatedCustomers as $cusId) {
            $lines[] = "*Case:*";
            $lines[] = "*Name:* {$firstName} {$lastName}";
            $lines[] = "*Email:* {$email}";
            $lines[] = "*Customer:* {$cusId}";
            $lines[] = "*Payment Method:* {$paymentMethodId}";
            $lines[] = "----------------------";
        }
    }

    if (!empty($skippedCustomers)) {
        foreach ($skippedCustomers as $cusId) {
            $lines[] = "*Case:*";
            $lines[] = "*Name:* {$firstName} {$lastName}";
            $lines[] = "*Email:* {$email}";
            $lines[] = "*Customer:* {$cusId}";
            $lines[] = "*Payment Methods:* (cannot reuse PM for this customer)";
            $lines[] = "----------------------";
        }
    }

    $messageText = implode("\n", $lines);

    $payload = json_encode([
        "text" => $messageText
    ]);

    $ch = curl_init($webhookUrl);
    curl_setopt($ch, CURLOPT_POST, true);
    curl_setopt($ch, CURLOPT_POSTFIELDS, $payload);
    curl_setopt($ch, CURLOPT_HTTPHEADER, ['Content-Type: application/json']);
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
    $result = curl_exec($ch);
    curl_close($ch);

    return $result;
}

